<nav class="main-header navbar navbar-expand navbar-white navbar-light">
	<ul class="navbar-nav">
		<li class="nav-item">
			<a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
		</li>
	</ul>
	<ul class="navbar-nav ml-auto">
		<li class="nav-item dropdown">
			<a class="nav-link" data-toggle="dropdown" href="#">
				<i class="far fa-bell fa-lg"></i>
				<span class="badge badge-danger navbar-badge">{{ get_expired_memberships()->count() }}</span>
			</a>
			<div class="dropdown-menu dropdown-menu-lg scrollable-dropdown dropdown-menu-right ">
				<div class="bg-primary px-3 py-2  text-capitalize text-bold">
					{{ __('dashboard.expired_memberships') }}
				</div>
				@if(get_expired_memberships()->count() == 0)
				<p class="text-sm text-secondary px-3 py-2 text-center">{{ __('dashboard.notify_not_found') }}</p>
				@else
				@foreach(get_expired_memberships()->take(10) as $m)
				<a href="{{ route('membership.create', $m->member_id) }}" class="dropdown-item">
					<div class="media">
						<div class="img-circle notification-image mr-3"
							style="background-image: url('{{ img_url($m->profile_picture) }}');"></div>
						<div class="media-body">
							<h3 class="dropdown-item-title text-secondary">
								{{ $m->name }}
							</h3>
							<p class="text-sm text-secondary">{{ __('dashboard.notify_expiry_message', ['date' =>
								readable_date($m->valid_to)]) }}</p>
						</div>
					</div>
				</a>
				@endforeach
				<div class="dropdown-divider"></div>
				<a href="{{ route('member.expired') }}" class="dropdown-item dropdown-footer text-sm text-secondary">{{
					__('dashboard.see_all_expired') }}</a>
				@endif
			</div>
		</li>
		<li class="nav-item dropdown">
			<a class="nav-link" data-toggle="dropdown" href="#">
				<i class="far fa-envelope"></i>
				<span class="badge badge-danger navbar-badge">{{ get_unpaid_members()->count() }}</span>
			</a>
			<div class="dropdown-menu dropdown-menu-lg scrollable-dropdown dropdown-menu-right">
				<div class="bg-primary px-3 py-2 text-capitalize text-bold">
					{{ __('dashboard.unpaid_members') }}
				</div>
				@if(get_unpaid_members()->count() == 0)
				<p class="text-sm text-secondary px-3 py-2 text-center">{{ __('dashboard.notify_not_found') }}</p>
				@else
				@foreach(get_unpaid_members()->take(10) as $m)
				<a href="{{ route('transaction.create', $m->membership_id) }}" class="dropdown-item">
					<div class="media">
						<div class="img-circle notification-image mr-3"
							style="background-image: url(' {{ img_url($m->profile_picture) }} ');"></div>
						<div class="media-body">
							<h3 class="dropdown-item-title text-secondary">
								{{ $m->name }}
							</h3>
							<p class="text-sm text-secondary">
								{{ __('dashboard.notify_due_message', ['id' => $m->membership_id, 'symbol' =>
								currency_symbol(), 'amount' => round_off($m->due_amount)]) }}
						</div>
					</div>
				</a>
				@endforeach
				<div class="dropdown-divider"></div>
				<a href="{{ route('member.unpaid') }}" class="dropdown-item dropdown-footer text-sm text-secondary">{{
					__('dashboard.all_payments') }}</a>
				@endif
			</div>
		</li>
		<li class="nav-item dropdown ">
			<a class="nav-link d-flex align-items-center px-2" data-toggle="dropdown" href="#">
				<div class="img-circle elevation-1 user-profile-image-navbar mr-2"
					style="background-image: url(' {{ get_profile_picture(Auth::user()->id) }} ');"></div>
				<div>
					<p class="mb-0">{{ truncate_string( Auth::user()->name ,10) }} <i class="fas fa-angle-down"></i></p>
				</div>
			</a>
			<div class="dropdown-menu dropdown-menu scrollable-dropdown dropdown-menu-right p-0 mt-2">
				<a href="{{ route('user.profile', Auth::user()->id) }}" class="dropdown-item">
					<p class="mb-0 py-1 text-secondary">
						<i class="fas fa-user"></i>
						<span class="ml-2">{{ __('dashboard.profile') }}</span>
					</p>
				</a>
				<a href="{{ route('settings.index') }}" class="dropdown-item ">
					<p class="mb-0 py-1 text-secondary">
						<i class="fas fa-cog"></i>
						<span class="ml-2">{{ __('dashboard.settings') }}</span>
					</p>
				</a>
				<a type="button" class="dropdown-item " data-toggle="modal" data-target="#modal-default">
					<p class="mb-0 py-1 text-secondary">
						<i class="fas fa-sign-out-alt"></i>
						<span class="ml-2">{{ __('dashboard.logout') }}</span>
					</p>
				</a>
			</div>
		</li>
	</ul>
</nav>